/*
Standing stock of live trees, both live ag and bg carbon density and also volumes
from query of FIADB 

Estimates are ratio estimates modified from code provided with evalidator queries
The code generate two tables accoding to stand classifications -- by typegroup versus softwood/hardwood/woodland
The resulting .csv table (e.g., liveTreeStock_02Nov2022.csv)
  returned from oracle is the union tables and is exactly as it appears in the model

Column names are explained in the model, but briefly:
- columns 1-4 classify the forest stand
- LIVEAGC_TPA: live tree aboveground carbon, tons C/acre
- LIVEBGC_TPA: live tree belowground carbon, tons C/acre
- LIVEVOLCFNET_100CFPA: live tree net volume, 100ft**3/acre
- LIVEGSVOLCFNET_100CFPA: live tree net volume for growing-stock trees, 100ft**3/acre
- LIVEGSVOLCFNET_ML_100CFPA: live tree net volume for growing-stock trees in medium and large diameter stands, 100ft**3/acre
- LIVEVOLCFGRS_100CFPA: live tree gross volume, 100ft**3/acre
- the remaining columns are the numerator and denominator values used for the ratio estimates
4 01 groups 
   
See the FIADB database documentaion for additional informaion on data and methods  
https://www.fia.fs.usda.gov/library/database-documentation/index.php#FIADB 

05Oct2023, from 09Dec2022 jes 
*/
SELECT 
  num.conusRegion, 
  num.possibleTypes, 
  num.standOrigin, 
  num.ageBin, 
  num.ESTIMATE / den.ESTIMATE liveagC_tpa, 
  num.ESTIMATEbg / den.ESTIMATE livebgC_tpa, 
  num.ESTIMATEccfnet / den.ESTIMATE livevolcfnet_100cfpa, 
  num.ESTIMATEccfnetgs / den.ESTIMATE livegsvolcfnet_100cfpa, 
  num.ESTIMATEccfnetgs_ml / den.ESTIMATE livegsvolcfnet_ml_100cfpa, 
  num.ESTIMATEccfgrs / den.ESTIMATE livevolcfgrs_100cfpa, 
  num.ESTIMATE NUM_ESTIMATED_agCton, 
  num.ESTIMATEbg NUM_ESTIMATED_bgCton, 
  num.ESTIMATEccfnet NUM_ESTIMATED_100cfnetvol, 
  num.ESTIMATEccfnetgs NUM_ESTIMATED_100cfnetgsvol, 
  den.ESTIMATE DEN_ESTIMATED_ac 
FROM 
  (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ESTIMATED_VALUE * EXPNS) ESTIMATE, 
      sum(ESTIMATED_VALUEbg * EXPNS) ESTIMATEbg, 
      sum(ESTIMATED_VALUEcfnet * EXPNS)/ 100 ESTIMATEccfnet, 
      sum(ESTIMATED_VALUEcfnetgs * EXPNS)/ 100 ESTIMATEccfnetgs, 
      sum(
        ESTIMATED_VALUEcfnetgs_ml * EXPNS
      )/ 100 ESTIMATEccfnetgs_ml, 
      sum(ESTIMATED_VALUEcfgrs * EXPNS)/ 100 ESTIMATEccfgrs 
    FROM 
      (
        SELECT 
          case when (
            stdage between 0 
            and 20
          ) then '0-20 years' when (
            stdage between 21 
            and 40
          ) then '21-40 years' when (
            stdage between 41 
            and 60
          ) then '41-60 years' when (
            stdage between 61 
            and 80
          ) then '61-80 years' when (
            stdage between 81 
            and 100
          ) then '81-100 years' when (
            stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          refftgrp.meaning as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          
          /* get carbon_ag */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END * COALESCE(TREE.carbon_ag / 2000, 0)
          ) AS ESTIMATED_VALUE, 
          
          /* get carbon_ag */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END * COALESCE(TREE.carbon_bg / 2000, 0)
          ) AS ESTIMATED_VALUEbg, 
          
          /* volcfnet  */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * COALESCE(TREE.volcfnet, 0)
          ) AS ESTIMATED_VALUEcfnet, 
          
          /* volcfnet if growing stock (treeclcd=1  */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * case when tree.treeclcd = 2 then 1 else 0 end * COALESCE(TREE.volcfnet, 0)
          ) AS ESTIMATED_VALUEcfnetgs, 
          
          /* volcfnet if growing stock (treeclcd=1) and if stand size class is med and large  (STDSZCD  in (1,2)            */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * case when tree.treeclcd = 2 then 1 else 0 end * case when cond.stdszcd in (1, 2) then 1 else 0 end * COALESCE(TREE.volcfnet, 0)
          ) AS ESTIMATED_VALUEcfnetgs_ml, 
          
          /* volcfgrs  */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * COALESCE(TREE.volcfgrs, 0)
          ) AS ESTIMATED_VALUEcfgrs 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          JOIN FS_FIADB.PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.COND ON (COND.PLT_CN = PLOT.CN) 
          JOIN FS_FIADB.TREE ON (
            TREE.PLT_CN = COND.PLT_CN 
            AND TREE.CONDID = COND.CONDID
          ) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          TREE.STATUSCD = 1 
          AND COND.COND_STATUS_CD = 1 
          /* conus46 and the 2 split states */

 		  --AND ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101) )
		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )

			
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          cond.trtcd1, 
          cond.trtcd2, 
          cond.trtcd3, 
          refftgrp.meaning, 
          cond.stdage, 
          cond.stdszcd, 
          cond.dstrbcd1, 
          cond.dstrbcd2, 
          cond.dstrbcd3, 
          refft.typgrpcd
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) num 
  join (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ESTIMATED_VALUE * EXPNS) ESTIMATE 
    FROM 
      (
        select 
          case when (
            stdage between 0 
            and 20
          ) then '0-20 years' when (
            stdage between 21 
            and 40
          ) then '21-40 years' when (
            stdage between 41 
            and 60
          ) then '41-60 years' when (
            stdage between 61 
            and 80
          ) then '61-80 years' when (
            stdage between 81 
            and 100
          ) then '81-100 years' when (
            stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          refftgrp.meaning as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ESTIMATED_VALUE 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          JOIN FS_FIADB.PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.COND ON (COND.PLT_CN = PLOT.CN) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          COND.COND_STATUS_CD = 1 
          AND COND.CONDPROP_UNADJ IS NOT NULL 
          /* conus46 and the 2 split states */

  		  --AND ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101) )
		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )

			
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          case when (
            stdage between 0 
            and 20
          ) then '0-20 years' when (
            stdage between 21 
            and 40
          ) then '21-40 years' when (
            stdage between 41 
            and 60
          ) then '41-60 years' when (
            stdage between 61 
            and 80
          ) then '61-80 years' when (
            stdage between 81 
            and 100
          ) then '81-100 years' when (
            stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          cond.trtcd1, 
          cond.trtcd2, 
          cond.trtcd3, 
          refftgrp.meaning, 
          cond.stdage, 
          cond.stdszcd, 
          cond.dstrbcd1, 
          cond.dstrbcd2, 
          cond.dstrbcd3, 
          refft.typgrpcd
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) den ON num.conusRegion = den.conusRegion 
  AND num.possibleTypes = den.possibleTypes 
  AND num.standOrigin = den.standOrigin 
  AND num.ageBin = den.ageBin 
union 
SELECT 
  num.conusRegion, 
  num.possibleTypes, 
  num.standOrigin, 
  num.ageBin, 
  num.ESTIMATE / den.ESTIMATE liveagC_tpa, 
  num.ESTIMATEbg / den.ESTIMATE livebgC_tpa, 
  num.ESTIMATEccfnet / den.ESTIMATE livevolcfnet_100cfpa, 
  num.ESTIMATEccfnetgs / den.ESTIMATE livegsvolcfnet_100cfpa, 
  num.ESTIMATEccfnetgs_ml / den.ESTIMATE livegsvolcfnet_ml_100cfpa, 
  num.ESTIMATEccfgrs / den.ESTIMATE livevolcfgrs_100cfpa, 
  num.ESTIMATE NUM_ESTIMATED_agCton, 
  num.ESTIMATEbg NUM_ESTIMATED_bgCton, 
  num.ESTIMATEccfnet NUM_ESTIMATED_100cfnetvol, 
  num.ESTIMATEccfnetgs NUM_ESTIMATED_100cfnetgsvol, 
  den.ESTIMATE DEN_ESTIMATED_ac 
FROM 
  (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ESTIMATED_VALUE * EXPNS) ESTIMATE, 
      sum(ESTIMATED_VALUEbg * EXPNS) ESTIMATEbg, 
      sum(ESTIMATED_VALUEcfnet * EXPNS)/ 100 ESTIMATEccfnet, 
      sum(ESTIMATED_VALUEcfnetgs * EXPNS)/ 100 ESTIMATEccfnetgs, 
      sum(
        ESTIMATED_VALUEcfnetgs_ml * EXPNS
      )/ 100 ESTIMATEccfnetgs_ml, 
      sum(ESTIMATED_VALUEcfgrs * EXPNS)/ 100 ESTIMATEccfgrs 
    FROM 
      (
        SELECT 
          case when (
            stdage between 0 
            and 20
          ) then '0-20 years' when (
            stdage between 21 
            and 40
          ) then '21-40 years' when (
            stdage between 41 
            and 60
          ) then '41-60 years' when (
            stdage between 61 
            and 80
          ) then '61-80 years' when (
            stdage between 81 
            and 100
          ) then '81-100 years' when (
            stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          case when refft.typgrpcd in (180, 970) then 'predominantly woodland species, type not known' when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)' when refft.typgrpcd < 400 then 'predominantly softwood species, type not known' else 'predominantly hardwood species, type not known' end as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          
          /* get carbon_ag */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END * COALESCE(TREE.carbon_ag / 2000, 0)
          ) AS ESTIMATED_VALUE, 
          
          /* get carbon_ag */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(TREE.DIA, 5 - 0.001) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_MICR ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END END * COALESCE(TREE.carbon_bg / 2000, 0)
          ) AS ESTIMATED_VALUEbg, 
          
          /* volcfnet  */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * COALESCE(TREE.volcfnet, 0)
          ) AS ESTIMATED_VALUEcfnet, 
          
          /* volcfnet if growing stock (treeclcd=1  */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * case when tree.treeclcd = 2 then 1 else 0 end * COALESCE(TREE.volcfnet, 0)
          ) AS ESTIMATED_VALUEcfnetgs, 
          
          /* volcfnet if growing stock (treeclcd=1) and if stand size class is med and large  (STDSZCD  in (1,2)            */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * case when tree.treeclcd = 2 then 1 else 0 end * case when cond.stdszcd in (1, 2) then 1 else 0 end * COALESCE(TREE.volcfnet, 0)
          ) AS ESTIMATED_VALUEcfnetgs_ml, 
          
          /* volcfgrs  */
          SUM(
            TREE.TPA_UNADJ * CASE WHEN TREE.DIA IS NULL THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE CASE LEAST(
              TREE.DIA, 
              COALESCE(PLOT.MACRO_BREAKPOINT_DIA, 9999) -0.001
            ) WHEN TREE.DIA THEN POP_STRATUM.ADJ_FACTOR_SUBP ELSE POP_STRATUM.ADJ_FACTOR_MACR END END * COALESCE(TREE.volcfgrs, 0)
          ) AS ESTIMATED_VALUEcfgrs 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          JOIN FS_FIADB.PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.COND ON (COND.PLT_CN = PLOT.CN) 
          JOIN FS_FIADB.TREE ON (
            TREE.PLT_CN = COND.PLT_CN 
            AND TREE.CONDID = COND.CONDID
          ) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          TREE.STATUSCD = 1 
          AND COND.COND_STATUS_CD = 1 
          /* conus46 and the 2 split states */

 		  --AND ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101) )
		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )

			
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          cond.trtcd1, 
          cond.trtcd2, 
          cond.trtcd3, 
          refftgrp.meaning, 
          cond.stdage, 
          cond.stdszcd, 
          cond.dstrbcd1, 
          cond.dstrbcd2, 
          cond.dstrbcd3, 
          refft.typgrpcd
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) num 
  join (
    SELECT 
      conusRegion, 
      coalesce(possibleTypes, 'Unknown') as possibleTypes, 
      coalesce(standOrigin, 'Unknown') as standOrigin, 
      coalesce(ageBin, 'Unknown') as ageBin, 
      sum(ESTIMATED_VALUE * EXPNS) ESTIMATE 
    FROM 
      (
        select 
          case when (
            stdage between 0 
            and 20
          ) then '0-20 years' when (
            stdage between 21 
            and 40
          ) then '21-40 years' when (
            stdage between 41 
            and 60
          ) then '41-60 years' when (
            stdage between 61 
            and 80
          ) then '61-80 years' when (
            stdage between 81 
            and 100
          ) then '81-100 years' when (
            stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end as agebin, 
          case when refft.typgrpcd in (180, 970) then 'predominantly woodland species, type not known' when refft.typgrpcd in (999) then 'not sure, very few trees (ie, nonstocked)' when refft.typgrpcd < 400 then 'predominantly softwood species, type not known' else 'predominantly hardwood species, type not known' end as possibleTypes, 
          case when cond.stdorgcd = 1 then 'Planted' else 'Natural' end as standOrigin, 
          case when cond.statecd in(
            9, 10, 11, 23, 24, 25, 33, 34, 36, 42, 44, 
            50, 54
          ) then 'Northeast' when cond.statecd in(17, 18, 19, 29, 39) then 'Central States' when cond.statecd in(20, 31, 38, 46) then 'Great Plains' when cond.statecd in(26, 27, 55) then 'Northern Lake States' when (
            cond.statecd in(40, 48) 
            and cond.unitcd in(3, 4, 5, 6, 7)
          ) then 'Great Plains' when cond.statecd in(1, 5, 21, 22, 28, 40, 47, 48) then 'South Central' when cond.statecd in(12, 13, 37, 45, 51) then 'Southeast' when cond.statecd in(16, 30) then 'Rocky Mountain North' when cond.statecd in(4, 8, 32, 35, 49, 56) then 'Rocky Mountain South' when cond.statecd in(6) then 'Pacific Southwest' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(0, 1, 2, 5, 6, 7)
          ) then 'Pacific Northwest Westside' when (
            cond.statecd in(41, 53) 
            and cond.unitcd in(3, 4, 8, 9)
          ) then 'Pacific Northwest Eastside' else 'not located' end as conusRegion, 
          pop_stratum.expns EXPNS, 
          SUM(
            COND.CONDPROP_UNADJ * CASE COND.PROP_BASIS WHEN 'MACR' THEN POP_STRATUM.ADJ_FACTOR_MACR ELSE POP_STRATUM.ADJ_FACTOR_SUBP END
          ) AS ESTIMATED_VALUE 
        FROM 
          FS_FIADB.POP_STRATUM POP_STRATUM 
          JOIN FS_FIADB.POP_PLOT_STRATUM_ASSGN ON (
            POP_PLOT_STRATUM_ASSGN.STRATUM_CN = POP_STRATUM.CN
          ) 
          JOIN FS_FIADB.PLOT ON (
            POP_PLOT_STRATUM_ASSGN.PLT_CN = PLOT.CN
          ) 
          JOIN FS_FIADB.PLOTGEOM ON (PLOT.CN = PLOTGEOM.CN) 
          JOIN FS_FIADB.COND ON (COND.PLT_CN = PLOT.CN) 
          JOIN FS_FIADB.REF_FOREST_TYPE refft ON (COND.FORTYPCD = refft.VALUE) 
          JOIN FS_FIADB.REF_FOREST_TYPE_GROUP refftgrp ON (refftgrp.value = refft.typgrpcd) 
        WHERE 
          COND.COND_STATUS_CD = 1 
          AND COND.CONDPROP_UNADJ IS NOT NULL 
          /* conus46 and the 2 split states */

 		  --AND ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101) )
		  AND (
            ( pop_stratum.evalid in (12201, 41901, 52101, 61901, 81901, 92101,
             102101, 121901, 132101, 161901, 172101, 182101, 192101, 202001, 211901, 221901, 
             232101, 242101, 252001, 262101, 272101, 282101, 292101, 301901, 312101, 321901, 
             332101, 342001, 351901, 362001, 372201, 382101, 392101, 411901, 422101, 442101, 
             452101, 462101, 471901, 491901, 502101, 512101, 531901, 542101, 552101, 561801))  -- the 46  
              or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 481901)  -- TX west  
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 482121)  -- TX east 
            or 
            (POP_PLOT_STRATUM_ASSGN.unitcd in (3,4,5,6,7) and pop_stratum.evalid = 402001)  -- OK west   
            or
            (POP_PLOT_STRATUM_ASSGN.unitcd in (1,2) and pop_stratum.evalid = 402001)  -- OK east  
          )

			
        GROUP BY 
          pop_stratum.estn_unit_cn, 
          pop_stratum.cn, 
          plot.cn, 
          plot.lat, 
          plot.lon, 
          pop_stratum.expns, 
          case when (
            stdage between 0 
            and 20
          ) then '0-20 years' when (
            stdage between 21 
            and 40
          ) then '21-40 years' when (
            stdage between 41 
            and 60
          ) then '41-60 years' when (
            stdage between 61 
            and 80
          ) then '61-80 years' when (
            stdage between 81 
            and 100
          ) then '81-100 years' when (
            stdage between 101 
            and 998
          ) then '100+ years' else 'w/o age - row not selectable' end, 
          cond.stdorgcd, 
          cond.statecd, 
          cond.unitcd, 
          cond.trtcd1, 
          cond.trtcd2, 
          cond.trtcd3, 
          refftgrp.meaning, 
          cond.stdage, 
          cond.stdszcd, 
          cond.dstrbcd1, 
          cond.dstrbcd2, 
          cond.dstrbcd3, 
          refft.typgrpcd
      ) 
    GROUP BY 
      conusRegion, 
      cube(
        possibleTypes, standOrigin, ageBin
      ) 
    ORDER BY 
      conusRegion, 
      possibleTypes, 
      standOrigin, 
      ageBin
  ) den ON num.conusRegion = den.conusRegion 
  AND num.possibleTypes = den.possibleTypes 
  AND num.standOrigin = den.standOrigin 
  AND num.ageBin = den.ageBin 
ORDER BY 
  conusRegion, 
  possibleTypes, 
  standOrigin, 
  ageBin
